﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUsersIndex : BaseAPIMethod
        {

            public MethodUsersIndex(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "usersindex"; }
            }

            private int _schoolId = 0;
            private int _instructorId = 0;
            private int _classId = 0;

            protected override void DoReadRequestParams()
            {
                string _school_id = Component.APIRequestParams["school_id"];
                if (!string.IsNullOrEmpty(_school_id))
                {
                    int.TryParse(_school_id, out _schoolId);
                }

                // UserID for Instructor
                string _instructor_id = Component.APIRequestParams["instructor_id"];
                if (!string.IsNullOrEmpty(_instructor_id))
                {
                    int.TryParse(_instructor_id, out _instructorId);
                }

                string _class_id = Component.APIRequestParams["class_id"];
                if (!string.IsNullOrEmpty(_class_id))
                {
                    int.TryParse(_class_id, out _classId);
                }
            }

            /// <summary>
            /// Tutaj musimy nadpisac walidacje bazowa, bo nie ma sesji
            /// wiec sprawdzamy tylko czy sa parametry w URLu wlasciwe
            /// </summary>
            /// <returns></returns>
            protected override bool IsValid()
            {
                return DoValidate();
            }
            
            protected override bool DoValidate()
            {
                if (_schoolId > 0 || _instructorId > 0)
                {
                    return true;
                }
                AddErrorMessage("Podano nieprawidłowy identyfikator szkoły lub instruktora.");
                return false;
            }

            protected override GResponseData DoGetGResponseData()
            {
                List<GUsersIndex> _listGUsersIndex = Component.BLELearning.APIMobile.GetGUsersIndexList(_schoolId, _instructorId, _classId);
                if (_listGUsersIndex != null && _listGUsersIndex.Count > 0)
                {
                    StatusCode = StatusCodeType.OK;
                    return new GResponseData_UsersIndex() { Users = _listGUsersIndex, count = _listGUsersIndex.Count };
                }
                AddErrorMessage("Dla podanej szkoły lub/i instruktora nie znaleziono uczniów.");
                StatusCode = StatusCodeType.NotFound;
                return null;
            }
        }
    }
}